(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30929,        874]*)
(*NotebookOutlinePosition[     31650,        899]*)
(*  CellTagsIndexPosition[     31606,        895]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Ecuaciones diferenciales. Respuesta impulsiva, soluci\[OAcute]n de estado \
estacionario y funci\[OAcute]n delta de Dirac.\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author"],

Cell[CellGroupData[{

Cell["\<\
Respuesta impulsiva y soluci\[OAcute]n de estado estacionario de una EDL\
\>", "Section"],

Cell["Consideremos una ED lineal con coeficinetes constantes", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\(y\^\((n)\) + \(c\_\(n - 1\)\) 
              y\^\((n - 1)\) + \(c\_\(n - 2\)\) 
              y\^\((n - 2)\) +  ... \) + \(c\_1\) y' + \(c\_0\) y = 
      u(t)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que suponemos que modela un sistema LTI. La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`u(t)\)]],
  " es la se\[NTilde]al de entrada y la salida es la soluci\[OAcute]n del \
problema de valores iniciales (PVI )"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(y\^\((n)\) + \(c\_\(n - 1\)\) 
                y\^\((n - 1)\) + \(c\_\(n - 2\)\) 
                y\^\((n - 2)\) +  ... \) + \(c\_1\) y' + \(c\_0\) y = 
        u(t)\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(y(
          0) = \(\(y' \((0)\) =. \) ..  = \(\(y\^\((n - 2)\)\)(
              0) = \(\(y\^\((n - 1)\)\)(0) = 0\)\)\)\)\)\)]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Dicha soluci\[OAcute]n recibe el nombre de ",
  StyleBox["soluci\[OAcute]n de estado estacionario",
    FontWeight->"Bold"],
  " de la ED (1). La soluci\[OAcute]n del PVI"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\(y\^\((n)\) + \(c\_\(n - 1\)\) 
              y\^\((n - 1)\) + \(c\_\(n - 2\)\) 
              y\^\((n - 2)\) +  ... \) + \(c\_1\) y' + \(c\_0\) y = 
      0, \ \ \ \ y(
        0) = \(\(y' \((0)\) =. \) ..  = \(\(y\^\((n - 2)\)\)(0) = 
          0\)\), \ \(y\^\((n - 1)\)\)(0) = 1\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama ",
  StyleBox["respuesta",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["impulsiva ",
    FontWeight->"Bold"],
  "del sistema",
  ". Si representamos por ",
  Cell[BoxData[
      \(TraditionalForm\`h(t)\)]],
  " la respuesta impulsiva, se verifica que la soluci\[OAcute]n de estadao \
estacionario viene dada por la integral de convoluci\[OAcute]n"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(y(t)\), "=", 
        FormBox[\(\[Integral]\_0\%t\( u(x)\) \(h(t - x)\) \[DifferentialD]x\),
          
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En lo que sigue vamos a estudiar esto con la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["Ejemplo", "Example"],

Cell["Consideremos la ED lineal con coeficientes constantes  ", "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y''' \((t)\) - 3  y'' \((t)\) - y' \((t)\) + 
          3  y \((t)\) = u \((t)\)\)]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que suponemos modela un sistema LTI donde ",
  Cell[BoxData[
      \(TraditionalForm\`u(t)\)]],
  " es la se\[NTilde]al de entrada (input) e ",
  Cell[BoxData[
      \(TraditionalForm\`y \((t)\)\)]],
  " es la se\[NTilde]al de salida (output). Calculemos la respuesta impulsiva \
y la soluci\[OAcute]n de estado estacionario correspondiente al input ",
  Cell[BoxData[
      \(TraditionalForm\`u(t) = exp(t)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(ecdf = \(y'''\)[t] - 3 \( y''\)[t] - \(y'\)[t] + 
          3  y[t];\)\), "\[IndentingNewLine]", 
    \(resimp[t_] = 
      y[t] /. \(DSolve[{ecdf \[Equal] 0, 
              y[0] \[Equal] \(y'\)[0] \[Equal] 0, \(y''\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\), "\n", 
    \(solest[t_] = 
      y[t] /. \(DSolve[{ecdf \[Equal] Exp[t], 
                y[0] \[Equal] \(y'\)[0] \[Equal] 0 == \(y''\)[0]}, y, 
              t]\)[\([1]\)] // Expand\)}], "Input"],

Cell[TextData[{
  "Seguidamente comprobamos que la convoluci\[OAcute]n de la respuesta \
impulsiva con el input  ",
  Cell[BoxData[
      \(TraditionalForm\`u(t) = exp(t)\)]],
  " nos proporciona directamente la soluci\[OAcute]n de estado estacionario."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\_0\%t Exp[x] resimp[t - x] \[DifferentialD]x // 
      TrigToExp\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell["Caso general", "Example"],

Cell[TextData[{
  "Las capacidades simb\[OAcute]licas de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " permiten justificar el resultado anterior con completa generalidad. ",
  "Consideremos una ED lineal general con coeficientes constantes de orden n, \
cuyo primer coeficiente es igual a 1. "
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[\(\(y\^\((n)\) + c[n - 1] y\^\((n - 1)\) + 
                c[n - 2] y\^\((n - 2)\) +  ... \) + \ c[1] y' + c[0] y = 0\),
        FontFamily->"Times New Roman"], TraditionalForm]], "NumberedEquation",\

  TextAlignment->Center],

Cell[TextData[{
  "Intrerpretamos que dicha ED modela un sistema LTI en el cual la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " es la entrada y la salida es la soluci\[OAcute]n de estado estacionario \
de la correspondiente ED:"
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[\(\(y\^\((n)\) + c[n - 1] y\^\((n - 1)\) + 
                c[n - 2] y\^\((n - 2)\) +  ... \) + \ c[1] y' + c[0] y = 
          f(t)\),
        FontFamily->"Times New Roman"], TraditionalForm]], "NumberedEquation",\

  TextAlignment->Center],

Cell["Empecemos definiendo la ED de forma apropiada.", "Text"],

Cell[BoxData[
    \(ecu[y_, n_] := 
      Sum[c[k]*D[y[t], {t, k}], {k, 0, n}] /. c[n] \[Rule] 1\)], "Input"],

Cell[BoxData[
    \(ecu[y, 7]\)], "Input"],

Cell[TextData[{
  "Seguidamente, definimos una funci\[OAcute]n que calcula la convoluci\
\[OAcute]n de dos funciones a las que interpretamos como el input, ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " y la respuesta impulsiva ",
  Cell[BoxData[
      \(TraditionalForm\`imp(t)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(conv[
          t_] := \[Integral]\_0\%t f[x] 
            imp[t - x] \[DifferentialD]x;\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe derivar esta funci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(D[conv[t], t]\)], "Input"],

Cell["\<\
Veamos el aspecto de la ED (1) para n=4 cuando se sustituye en ella la funci\
\[OAcute]n de convoluci\[OAcute]n anterior.\
\>", "Text"],

Cell[BoxData[
    \(ecu[conv, 4]\)], "Input"],

Cell[TextData[{
  "Aqu\[IAcute] es dif\[IAcute]cil ver lo que interesa porque ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplifica a su manera que, en este caso, no es la m\[AAcute]s apropiada. \
Vamos a dar unas reglas de simplificaci\[OAcute]n para que agrupe \
integrales."
}], "Text"],

Cell[BoxData[{
    \(\(regla1 = 
        w_ \(\[Integral]\_0\%t f[x]*
                z__ \[DifferentialD]x\) \[RuleDelayed] \[Integral]\_0\%t f[x]*
              w*z \[DifferentialD]x;\)\), "\[IndentingNewLine]", 
    \(\(regla2 = \((\ \[Integral]\_0\%t u___*f[x]*
                  z_ \[DifferentialD]x + \[Integral]\_0\%t v___*f[x]*
                  w_ \[DifferentialD]x)\) \[RuleDelayed] \ \[Integral]\_0\%t 
                f[x]*\((u*z + 
                  v*w)\) \[DifferentialD]x;\)\), "\[IndentingNewLine]", 
    \(\((Expand[ecu[conv, 4]] //. regla1)\) //. regla2\)}], "Input"],

Cell[TextData[{
  "Ahora sustituimos en esta expresi\[OAcute]n las condiciones iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`imp \((0)\) = \(imp' \((0)\) = \(imp'' \((0)\) = 
            0\)\), \ imp''' \((0)\) = 1\)]],
  ", que debe verificar la respuesta impulsiva."
}], "Text"],

Cell[BoxData[{
    \(\(inicialesimp = 
        Append[Table[\((D[imp[t], {t, k}] /. t \[Rule] 0)\) \[Rule] 0, {k, 0, 
              2}], \((D[imp[t], {t, 3}] /. t \[Rule] 0)\) \[Rule] 
            1];\)\), "\[IndentingNewLine]", 
    \(%% /. inicialesimp\)}], "Input"],

Cell["\<\
Ya se aprecia claramente que lo que queda dentro de la integral es nulo \
porque la funci\[OAcute]n impulsiva es soluci\[OAcute]n de la ED (1). Condici\
\[OAcute]n que vamos a usar seguidamente.\
\>", "Text"],

Cell[BoxData[{
    \(\(solimp = \((ecu[imp, 4] /. t \[Rule] t - x)\) \[Rule] 
          0;\)\), "\[IndentingNewLine]", 
    \(%% /. solimp\)}], "Input"],

Cell[TextData[{
  "En resumen, hemos comprobado para n=4, que la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(conv(t)\), "=", 
          
          FormBox[\(\[Integral]\_0\%t\( f(x)\) \(imp(
                  t - x)\) \[DifferentialD]x\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es soluci\[OAcute]n de la ED (2). Queda por cmprobar que se trata de la \
soluci\[OAcute]n de estado estacionario, es decir, que su valor y el de sus \
tres primeras derivadas en 0 es igual a 0. Pero eso es f\[AAcute]cil de \
comprobar."
}], "Text"],

Cell[BoxData[
    \(Table[\((D[conv[t], {t, k}] /. t \[Rule] 0)\), {k, 0, 3}] /. 
      inicialesimp\)], "Input"],

Cell[TextData[{
  "Con la facilidad que proporciona ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", es inmediato convertir el procedimento anterior en un programa que \
comprueba que la convoluci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(conv(t)\), "=", 
          
          FormBox[\(\[Integral]\_0\%t\( f(x)\) \(imp(
                  t - x)\) \[DifferentialD]x\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es soluci\[OAcute]n de estado estacionario de la ED (2)."
}], "Text"],

Cell[BoxData[{
    \(Clear[inicialesimp, solimp]\), "\[IndentingNewLine]", 
    \(\(inicialesimp[n_] := 
        Append[Table[\((D[imp[t], {t, k}] /. t \[Rule] 0)\) \[Rule] 0, {k, 0, 
              n - 2}], \((D[imp[t], {t, n - 1}] /. t \[Rule] 0)\) \[Rule] 
            1];\)\), "\[IndentingNewLine]", 
    \(\(solimp[n_] := \((ecu[imp, n] /. t \[Rule] t - x)\) \[Rule] 
          0;\)\), "\[IndentingNewLine]", 
    \(\(solestacionario[n_] := 
        Simplify[\[IndentingNewLine]\((\((\((Expand[
                          ecu[conv, n] /. inicialesimp[n]] //. regla1)\) //. 
                    regla2)\) /. solimp[n])\) \[Equal] 
            f[t]];\)\), "\[IndentingNewLine]", 
    \(iniestacionario[n_] := 
      Table[\((D[conv[t], {t, k}] /. t \[Rule] 0)\), {k, 0, n - 1}] /. 
        Append[Table[\((D[imp[t], {t, k}] /. t \[Rule] 0)\) \[Rule] 0, {k, 0, 
              n - 2}], \((D[imp[t], {t, n - 1}] /. t \[Rule] 0)\) \[Rule] 
            1]\)}], "Input"],

Cell[BoxData[{
    \({solestacionario[4], iniestacionario[4]}\), "\[IndentingNewLine]", 
    \({solestacionario[12], iniestacionario[12]}\)}], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Respuesta impulsiva y Delta de Dirac", "Section"],

Cell[TextData[{
  "Consideremos un sistema LTI cuya salida (output) ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " y entrada (input) ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " est\[AAcute]n relacionadas por la ED "
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(y'' \((t)\) + c\ y' \((t)\) + 
            d\ \(y(t)\) = \(\(f\) \((t)\)\(\ \)\)\),
        "TraditionalForm"], TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0, \ d > 0\)]],
  ". La ",
  StyleBox["respuesta impulsiva",
    FontSlant->"Italic"],
  " de dicho sistema es la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + c\ y' \((t)\) + d\ \(y(t)\) = 0\)]],
  " con las condiciones ",
  Cell[BoxData[
      \(TraditionalForm\`y[0] = 0, \ \(y'\)[0] = 1\)]],
  ". La respuesta impulsiva depende de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`c > 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`d > 0\)]],
  " y de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Sabemos que la soluci\[OAcute]n de estado estacionario viene dada por la \
integral de convoluci\[OAcute]n  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[t - x]\),
              "TraditionalForm"], \(f[x]\), \(\[DifferentialD]x\)}]}], 
        TraditionalForm]]],
  ". Vamos a comprobar esto con ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "en algunos casos particulares y no lo haremos de forma simb\[OAcute]lica \
como antes sino haciendo los c\[AAcute]lculos correspondientes para algunas \
funciones ",
  Cell[BoxData[
      \(TraditionalForm\`f \((t)\)\)]],
  ". \nEn la celda siguiente calculamos la respuesta impulsiva y la soluci\
\[OAcute]n de estado estacionario para el imput ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = \[Lambda]\ Cos[\[Omega]\ t]\)]],
  ",  y comprobamos que dicha soluci\[OAcute]n es igual a"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[Integral]\_0\%t\), " ", 
          RowBox[{
            FormBox[\(impulsiva[t - x]\),
              "TraditionalForm"], \(f[\ 
              x]\), \(\(\[DifferentialD]x\)\(.\)\)}]}],
        "TraditionalForm"], TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[BoxData[
    \(\(\( (*\ 
      respuesta\ impulsiva\ *) \)\(\[IndentingNewLine]\)\(impulsiva[t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ d\ y[t] \[Equal] 0, 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\[IndentingNewLine] (*\ 
      soluci\[OAcute]n\ de\ estado\ estacionario\ *) \[IndentingNewLine]
    solestacionario[f_, t_] := 
      Collect[y[
            t] /. \(DSolve[{\(y''\)[t] + c\ \(y'\)[t] + \ d\ y[t] \[Equal] 
                  f[t], y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, y, 
              t]\)[\([1]\)], {\[ExponentialE]\^\(1\/2\ \((\(-c\) - \@\(c\^2 - \
4\ d\))\)\ t\), \[ExponentialE]\^\(1\/2\ \((\(-c\) + \@\(c\^2 - 4\ d\))\)\ \
t\), Cos[t\ \[Omega]], Sin[t\ \[Omega]]}, Simplify]\[IndentingNewLine] (*\ 
      convoluci\[OAcute]n\ input*respuestaimpulsiva\ *) \[IndentingNewLine]
    \(f[t_] = \[Lambda]\ Cos[\[Omega]\ t];\)\[IndentingNewLine]
    solestacionario[f, t]\[IndentingNewLine]
    Simplify[
      Integrate[impulsiva[t - x]\ f[x], {x, 0, t}]]\[IndentingNewLine] (*\ 
      comprobaci\[OAcute]n\ final\ *) \[IndentingNewLine]
    Simplify[% - solestacionario[f, t]]\)\)\)], "Input"],

Cell[TextData[{
  "Naturalmente, podemos cambiar la funci\[OAcute]n input siempre que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " pueda hacer las correspondientes primitivas de forma simb\[OAcute]lica."
}], "Text"],

Cell[BoxData[{
    \(\(f[t_] = Exp[\[Omega]\ t];\)\), "\[IndentingNewLine]", 
    \(Simplify[
      Integrate[impulsiva[t - x] f[x], {x, 0, t}]]\), "\[IndentingNewLine]", 
    \(Simplify[% - solestacionario[f, t]]\)}], "Input"],

Cell[TextData[{
  "Hay una forma de interpretar la respuesta impulsiva que es muy intuitiva \
desde un punto de vista f\[IAcute]sico: la respuesta impulsiva es la \
respuesta del sistema a una fuerza externa s\[UAcute]bita e \
instant\[AAcute]nea (en t\[EAcute]rminos coloquiales: la respuesta impulsiva \
es la respuesta del sistema a un impulso). Matem\[AAcute]ticamente, una \
fuerza s\[UAcute]bita e instant\[AAcute]nea puede aproximarse por un impulso \
de duraci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] > 0\)]],
  " e intensidad ",
  Cell[BoxData[
      \(TraditionalForm\`1/\[Epsilon]\)]],
  ". La siguiente funci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`impulso[t, \[Epsilon]]\)]],
  ",  permite visualizar este impulso (consulta, si es preciso, en la ayuda \
del programa la funci\[OAcute]n UnitStep[ ])."
}], "Text"],

Cell[BoxData[
    \(\(\(\(impulso[
          t_, \[Epsilon]_] = \((UnitStep[t] - 
              UnitStep[t - \[Epsilon]])\)/\[Epsilon];\)\[IndentingNewLine]
    \(\(\(Plot[impulso[t, 1/1000], {t, \(- .01\),  .01}]\) \);\)\)\( (*\ 
      observa\ la\ escala\ de\ los\ ejes\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Vamos a calcular, usando NDSolve[ ], la soluci\[OAcute]n de estado \
estacionario de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] = 
        impulso[t, \[Epsilon]]\)]],
  " es decir, la soluci\[OAcute]n de dicha ED que satisface las condiciones \
iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 0, \ y' \((0)\) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " en el intervalo [0,10]. LLamaremos a esta soluci\[OAcute]n \
\"respuestaimpulso[\[Epsilon]][t]\"."
}], "Text"],

Cell[BoxData[
    \(respuestaimpulso[\[Epsilon]_] := 
      y /. \(NDSolve[{\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] \[Equal] 
                impulso[t, \[Epsilon]], 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, 
            y, {t, 0, 10}]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Calculamos ahora, con DSolve[ ], la respuesta impulsiva de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(y''\)[t] + \(y'\)[t] + \ y[t] = 0\)]],
  ", es decir, la soluci\[OAcute]n de dicha ED que satisface las condiciones \
iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 0, \ y' \((0)\) = 1\)]],
  ". Llamaremos a esta funci\[OAcute]n \"respuestaimpulsiva[t]\"."
}], "Text"],

Cell[BoxData[
    \(respuestaimpulsiva[t_] = 
      y[t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + \ \ y[t] \[Equal] 0, 
              y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
            t]\)[\([1]\)]\)], "Input"],

Cell["\<\
Representamos gr\[AAcute]ficamente, en la misma gr\[AAcute]fica, las \
funciones respuestaimpulsiva[t] y respuestaimpulso[1-\[Delta]][t] donde \
\[Delta] toma valores desde .11 hasta .99 con incrementos de .11. \
\>", "Text"],

Cell[BoxData[{
    \(\(Do[
        Plot[{\(respuestaimpulso[1 - \[Delta]]\)[t], 
            respuestaimpulsiva[t]}, {t, 0, 10}, 
          PlotStyle \[Rule] {Hue[0], 
              Hue[ .65]}], {\[Delta],  .11,  .99,  .11}];\)\), "\
\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "Gr\[AAcute]ficamente se observa que la respuestaimpulso[\[Epsilon]][t] se \
aproxima a la respuestaimpulsiva[t] cuando \[Epsilon]\[Rule]0. Podemos \
comprobar simb\[OAcute]licamente que esto es as\[IAcute] con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Para ello, vamos a calcular simb\[OAcute]licamente la respuestaimpulso[\
\[Epsilon]]. Hay que darle una ayudita al programa que consiste en hacer los \
c\[AAcute]lculos en dos partes teniendo en cuenta que ",
  Cell[BoxData[
      \(TraditionalForm\`\(impulso[\[Epsilon]]\)[
          t] = \(UnitStep[t] - UnitStep[t - \[Epsilon]]\)\/\[Epsilon]\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(y1[\[Epsilon]_]\)[t_] = 
      Collect[y[
              t] /. \(DSolve[{\(y''\)[t] + \ \(y'\)[t] + \ y[t] \[Equal] 
                    UnitStep[t]/\[Epsilon], 
                  y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}\ , y, t]\)[\([1]\)] // 
          Simplify, {Cos[x_], Sin[x_]}, Simplify]\)], "Input"],

Cell[BoxData[{
    \(\(H[t_] = 
        y[t] /. \(DSolve[\(y''\)[t] + \ \(y'\)[t] + \ y[t] \[Equal] 
                  UnitStep[t - \[Epsilon]]/\[Epsilon]\ , y[t], t]\)[\([1]\)] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(\(Simplify[\(Solve[{H[0] \[Equal] 0, \(H'\)[0] \[Equal] 0}, {C[1], 
              C[2]}]\)[\([\)\(1\)\(]\)], \[Epsilon] > 
          0];\)\), "\[IndentingNewLine]", 
    \(\(y2[\[Epsilon]_]\)[t_] = 
      Collect[H[t] /. %, {Cos[x_], Sin[x_]}]\)}], "Input"],

Cell["Tenemos, por tanto, que:", "Text"],

Cell[BoxData[{
    \(Clear[respuestaimpulso]\), "\[IndentingNewLine]", 
    \(\(respuestaimpulso[\[Epsilon]_]\)[
        t_] = \(y1[\[Epsilon]]\)[t] - \(y2[\[Epsilon]]\)[t]\)}], "Input"],

Cell["Comprobamos que efectivamente es as\[IAcute].", "Text"],

Cell[BoxData[{
    \(Simplify[\(respuestaimpulso[\[Epsilon]]''\)[
          t] + \(respuestaimpulso[\[Epsilon]]'\)[
          t] + \(respuestaimpulso[\[Epsilon]]\)[t], 
      0 < t < \[Epsilon]]\), "\[IndentingNewLine]", 
    \(Simplify[\(respuestaimpulso[\[Epsilon]]''\)[
          t] + \(respuestaimpulso[\[Epsilon]]'\)[
          t] + \(respuestaimpulso[\[Epsilon]]\)[t], 
      0 < \[Epsilon] < t]\), "\[IndentingNewLine]", 
    \(Simplify[\(respuestaimpulso[\[Epsilon]]''\)[
          t] + \(respuestaimpulso[\[Epsilon]]'\)[
          t] + \(respuestaimpulso[\[Epsilon]]\)[t], 
      0 < \[Epsilon] && t < 0]\), "\[IndentingNewLine]", 
    \(Simplify[{\(respuestaimpulso[\[Epsilon]]\)[
          0], \(respuestaimpulso[\[Epsilon]]'\)[0]}, \[Epsilon] > 
        0]\)}], "Input"],

Cell[BoxData[
    \(Limit[\(respuestaimpulso[\[Epsilon]]\)[t], \[Epsilon] \[Rule] 0, 
      Direction \[Rule] \(-1\)]\)], "Input"],

Cell[TextData[{
  "Hemos obtenido que, para valores de",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(t \[GreaterEqual] 0\)\)\)]],
  ", el l\[IAcute]mite para \[Epsilon]\[Rule]0 de la funci\[OAcute]n \
respuesta impulso es la respuesta impulsiva."
}], "Text"],

Cell[TextData[{
  "A la vista de estos resultados, queda claro que la respuesta impulsiva del \
sistema es el l\[IAcute]mite para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  " de la respuesta estacionaria del sistema al \"impulso de duraci\[OAcute]n \
\[Epsilon]\", impulso[t,\[Epsilon]]. Llamemos, ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t)\)]],
  " a la primera e ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t, \[Epsilon])\)]],
  " a la segunda. Seg\[UAcute]n acabamos de ver, ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t) = 
        lim\_\(\[Epsilon] \[Rule] 0\)\(y\_imp\)(t, \[Epsilon])\)]],
  ". Por otra parte, se verifica que"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t, \[Epsilon])\) + 
        y\_imp' \((t, \[Epsilon])\) + \(y\_imp\)(t, \[Epsilon]) = 
      impulso(t, \[Epsilon]), \ \(y\_imp\)(0, \[Epsilon]) = 0, \ 
    y\_imp' \((0, \[Epsilon])\) = 0\)]]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t)\) + y\_imp' \((t)\) + \(y\_imp\)(t) = 
      0, \(y\_imp\)(0) = 
      0, \ \(\(y\_imp' \((0)\)\)\(=\)\(1\)\(\ \)\)\)]]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "A la vista de estos resultados, todo parece indicar que si en el problema \
de valores iniciales (5) tomamos l\[IAcute]mites para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  ", entonces dicho PVI se convierte en el PVI (6). Aqu\[IAcute] hay algunas \
dificultades matem\[AAcute]ticas. La primera es que la operaci\[OAcute]n de \
derivar rara vez conmuta con la de paso al l\[IAcute]mite. En general, no es \
lo mismo derivar primero y tomar l\[IAcute]mite despu\[EAcute]s que invertir \
el proceso. Por tanto, que se verifique que ",
  Cell[BoxData[
      \(TraditionalForm\`\(y\_imp\)(t) = 
        lim\_\(\[Epsilon] \[Rule] 0\)\(y\_imp\)(t, \[Epsilon])\)]],
  " no garantiza que ",
  Cell[BoxData[
      \(TraditionalForm\`y\_imp' \((t)\) = 
        lim\_\(\[Epsilon] \[Rule] 0\)y\_imp' \((t, \[Epsilon])\)\)]],
  " y, menos a\[UAcute]n, que ",
  Cell[BoxData[
      \(TraditionalForm\`y\_imp'' \((t)\) = 
        lim\_\(\[Epsilon] \[Rule] 0\)y\_imp'' \((t, \[Epsilon])\)\)]],
  ".   Pero hay otra dificultad que salta a la vista: la condici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(y\_imp' \((0, \[Epsilon])\) = 0\)\)\)]],
  " dif\[IAcute]cilmente se puede convertir en el l\[IAcute]mite en la \
condici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y\_imp' \((0, 0)\) = 1. \)]],
  " Adem\[AAcute]s, se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(\[Epsilon] \[Rule] 0\)impulso(
            t, \[Epsilon]) = 0\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[NotEqual] 0\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{Cell["mientras "], "que"}], TraditionalForm]]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\ \)]],
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(\[Epsilon] \[Rule] 0\)impulso(
            0, \[Epsilon]) = \(+\[Infinity]\)\)]],
  ". Pero dejemos hablar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    \(Limit[impulso[t, \[Epsilon]], \[Epsilon] \[Rule] 0, 
      Direction \[Rule] \(-1\), 
      Assumptions \[Rule] t \[NotEqual] 0]\), "\[IndentingNewLine]", 
    \(Limit[impulso[0, \[Epsilon]], \[Epsilon] \[Rule] 0, 
      Direction \[Rule] \(-1\)]\)}], "Input"],

Cell["\<\
Por otra parte, observa que lo que estamos calculando es una derivada.\
\>", "Text"],

Cell[BoxData[
    \(impulso[t, \[Epsilon]] /. \[Epsilon] \[Rule] \(-\[Epsilon]\) // 
      Simplify\)], "Input"],

Cell[TextData[{
  "El l\[IAcute]mite de esta funci\[OAcute]n para \[Epsilon]\[Rule]0 es, por \
definici\[OAcute]n, la derivada de la funci\[OAcute]n UnitStep[ ] en el punto \
",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". Esa derivada no tiene ning\[UAcute]n problema en puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t \[NotEqual] 0\)]],
  " pero para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " no existe (o vale ",
  Cell[BoxData[
      \(TraditionalForm\`\(+\[Infinity]\)\)]],
  "). Veamos lo que sabe ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de la derivada de la funci\[OAcute]n UnitStep[ ]."
}], "Text"],

Cell[BoxData[
    \(D[UnitStep[t], t]\)], "Input"],

Cell["\<\
\[DownExclamation]Acaba de aparecer la famos\[IAcute]sima \"delta de Dirac\". \
Veamos algo sobre ella.\
\>", "Text"],

Cell[BoxData[{
    \(DiracDelta[34]\), "\[IndentingNewLine]", 
    \(DiracDelta[\(-2.89\)]\), "\[IndentingNewLine]", 
    \(DiracDelta[0]\), "\[IndentingNewLine]", 
    \(\(Plot[DiracDelta[t], {t, \(-1000\), 1000}];\)\)}], "Input"],

Cell["\<\
Pues, no parece gran cosa esta funci\[OAcute]n... En cero no est\[AAcute] \
definida y en los dem\[AAcute]s puntos se anula \[DownQuestion]Qu\[EAcute] \
puede hacerse con algo as\[IAcute]? Pese a todo, la intuici\[OAcute]n f\
\[IAcute]sica nos dice que si en la ED\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_imp'' \((t, \[Epsilon])\) + 
        y\_imp' \((t, \[Epsilon])\) + \(y\_imp\)(t, \[Epsilon]) = 
      impulso(t, \[Epsilon]), \ \(y\_imp\)(0, \[Epsilon]) = 0, \ 
    y\_imp' \((0, \[Epsilon])\) = 0\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "tomamos l\[IAcute]mites para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] \[Rule] 0\)]],
  " y escribimos la ED"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y'' \((t)\) + y' \((t)\) + y(t) = DiracDelta(t), \ 
    y(0) = 0, \ y' \((0)\) = 1\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Entonces la soluci\[OAcute]n de esta ED ",
  StyleBox["deber\[IAcute]a ser la respuesta impulsiva",
    FontSlant->"Italic"],
  ". \[DownQuestion]Se producir\[AAcute] el milagro? Dejemos que nos lo diga \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(y[t] /. \(DSolve[{\(y''\)[t] + \(y'\)[t] + y[t] \[Equal] DiracDelta[t], 
            y[0] \[Equal] 0, \(y'\)[0] \[Equal] 1}, y, 
          t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Pues \[DownExclamation]SI! hemos recuperado la respuesta impulsiva. Para \
ser exactos, la soluci\[OAcute]n obtenida es igual a la respuesta impulsiva \
para ",
  Cell[BoxData[
      \(TraditionalForm\`t > 0\)]],
  " y se anula para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[LessEqual] 0\)]],
  ". Esto no es magia matem\[AAcute]tica. La funci\[OAcute]n DiracDelta[ ] no \
es tratada por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " como una funci\[OAcute]n usual porque no lo es. Los fundamentos matem\
\[AAcute]ticos que justifican los c\[AAcute]lculos usuales con la funci\
\[OAcute]n DiracDelta[ ] y otras de su estilo no son en absoluto elementales \
y constituyen una de las teor\[IAcute]as m\[AAcute]s celebradas de las Matem\
\[AAcute]ticas del siglo XX: la llamada ",
  StyleBox["teor\[IAcute]a de distribuciones o funciones generalizadas.",
    FontSlant->"Italic"],
  " Para terminar, veamos lo que pasa al calcular la soluci\[OAcute]n de \
estado estacionario para la funci\[OAcute]n DiracDelta[ ]."
}], "Text"],

Cell[BoxData[
    \(y[t] /. \(DSolve[{\(y''\)[t] + \(y'\)[t] + y[t] \[Equal] DiracDelta[t], 
            y[0] \[Equal] 0, \(y'\)[0] \[Equal] 0}, y, 
          t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Hemos obtenido la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-respuestaimpulsiva[t]\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`t < 0\)]],
  " e igual a 0 para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0. \)]]
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 147, 3, 249, "Title"],
Cell[1904, 56, 148, 4, 123, "Author"],

Cell[CellGroupData[{
Cell[2077, 64, 99, 2, 93, "Section"],
Cell[2179, 68, 70, 0, 41, "Text"],
Cell[2252, 70, 251, 5, 36, "Text"],
Cell[2506, 77, 258, 6, 67, "Text"],
Cell[2767, 85, 454, 12, 41, "Text"],
Cell[3224, 99, 202, 5, 41, "Text"],
Cell[3429, 106, 372, 7, 36, "Text"],
Cell[3804, 115, 420, 14, 67, "Text"],
Cell[4227, 131, 230, 6, 60, "Text"],
Cell[4460, 139, 145, 5, 41, "Text"],
Cell[4608, 146, 26, 0, 51, "Example"],
Cell[4637, 148, 71, 0, 41, "Text"],
Cell[4711, 150, 185, 6, 41, "Text"],
Cell[4899, 158, 449, 12, 67, "Text"],
Cell[5351, 172, 486, 10, 150, "Input"],
Cell[5840, 184, 265, 6, 67, "Text"],
Cell[6108, 192, 109, 2, 92, "Input"],
Cell[6220, 196, 47, 1, 72, "Input"],
Cell[6270, 199, 31, 0, 51, "Example"],
Cell[6304, 201, 318, 7, 67, "Text"],
Cell[6625, 210, 269, 6, 37, "NumberedEquation"],
Cell[6897, 218, 271, 7, 67, "Text"],
Cell[7171, 227, 283, 7, 37, "NumberedEquation"],
Cell[7457, 236, 62, 0, 41, "Text"],
Cell[7522, 238, 109, 2, 72, "Input"],
Cell[7634, 242, 42, 1, 72, "Input"],
Cell[7679, 245, 312, 9, 67, "Text"],
Cell[7994, 256, 125, 3, 92, "Input"],
Cell[8122, 261, 119, 4, 41, "Text"],
Cell[8244, 267, 46, 1, 72, "Input"],
Cell[8293, 270, 145, 3, 41, "Text"],
Cell[8441, 275, 45, 1, 72, "Input"],
Cell[8489, 278, 305, 7, 67, "Text"],
Cell[8797, 287, 586, 10, 170, "Input"],
Cell[9386, 299, 288, 6, 67, "Text"],
Cell[9677, 307, 268, 5, 124, "Input"],
Cell[9948, 314, 218, 4, 67, "Text"],
Cell[10169, 320, 152, 3, 98, "Input"],
Cell[10324, 325, 570, 13, 94, "Text"],
Cell[10897, 340, 113, 2, 72, "Input"],
Cell[11013, 344, 527, 14, 68, "Text"],
Cell[11543, 360, 965, 17, 306, "Input"],
Cell[12511, 379, 151, 2, 120, "Input"],
Cell[12665, 383, 47, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12749, 389, 55, 0, 93, "Section"],
Cell[12807, 391, 252, 8, 41, "Text"],
Cell[13062, 401, 218, 5, 35, "NumberedEquation"],
Cell[13283, 408, 1594, 44, 210, "Text"],
Cell[14880, 454, 336, 9, 57, "NumberedEquation"],
Cell[15219, 465, 1176, 20, 457, "Input"],
Cell[16398, 487, 229, 5, 67, "Text"],
Cell[16630, 494, 227, 4, 124, "Input"],
Cell[16860, 500, 865, 18, 145, "Text"],
Cell[17728, 520, 293, 5, 146, "Input"],
Cell[18024, 527, 567, 15, 93, "Text"],
Cell[18594, 544, 268, 5, 146, "Input"],
Cell[18865, 551, 412, 9, 67, "Text"],
Cell[19280, 562, 215, 4, 120, "Input"],
Cell[19498, 568, 235, 4, 67, "Text"],
Cell[19736, 574, 450, 9, 198, "Input"],
Cell[20189, 585, 656, 13, 124, "Text"],
Cell[20848, 600, 326, 6, 172, "Input"],
Cell[21177, 608, 494, 9, 172, "Input"],
Cell[21674, 619, 40, 0, 41, "Text"],
Cell[21717, 621, 186, 3, 120, "Input"],
Cell[21906, 626, 61, 0, 41, "Text"],
Cell[21970, 628, 782, 15, 250, "Input"],
Cell[22755, 645, 130, 2, 94, "Input"],
Cell[22888, 649, 265, 6, 41, "Text"],
Cell[23156, 657, 711, 17, 93, "Text"],
Cell[23870, 676, 302, 5, 35, "NumberedEquation"],
Cell[24175, 683, 232, 4, 35, "NumberedEquation"],
Cell[24410, 689, 1979, 49, 197, "Text"],
Cell[26392, 740, 281, 5, 120, "Input"],
Cell[26676, 747, 94, 2, 41, "Text"],
Cell[26773, 751, 112, 2, 94, "Input"],
Cell[26888, 755, 655, 19, 93, "Text"],
Cell[27546, 776, 50, 1, 94, "Input"],
Cell[27599, 779, 127, 3, 41, "Text"],
Cell[27729, 784, 231, 4, 172, "Input"],
Cell[27963, 790, 288, 5, 67, "Text"],
Cell[28254, 797, 290, 5, 38, "Text"],
Cell[28547, 804, 153, 5, 41, "Text"],
Cell[28703, 811, 172, 3, 35, "Text"],
Cell[28878, 816, 296, 9, 67, "Text"],
Cell[29177, 827, 185, 3, 120, "Input"],
Cell[29365, 832, 1062, 22, 171, "Text"],
Cell[30430, 856, 185, 3, 120, "Input"],
Cell[30618, 861, 295, 10, 41, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

